describe("Address Autocomplete Provider Registration",()=>{beforeEach(()=>{delete global.window.wc,Object.assign(global.window,{wc_address_autocomplete_params:{address_providers:JSON.stringify([{id:"test-provider",name:"Test provider"},{id:"wc-payments",name:"WooCommerce Payments"},{id:"provider-1",name:"Provider 1"},{id:"provider-2",name:"Provider 2"}])}}),jest.resetModules(),require("../utils/address-autocomplete-common"),require("../address-autocomplete")}),test("should successfully register a valid provider",()=>{const e=window.wc.addressAutocomplete.registerAddressAutocompleteProvider({id:"test-provider",canSearch:()=>{},search:()=>{},select:()=>{}});expect(e).toBe(!0),expect(console).not.toHaveErrored()}),test("should reject invalid provider (null, undefined, non-object)",()=>{[null,undefined,"string",123,!0].forEach(e=>{const t=window.wc.addressAutocomplete.registerAddressAutocompleteProvider(e);expect(t).toBe(!1),expect(console).toHaveErroredWith("Error registering address provider:","Address provider must be a valid object"),expect(console).toHaveErrored()})}),test("should handle missing wc_address_autocomplete_params",()=>{delete global.window.wc,global.window.wc_address_autocomplete_params=undefined,jest.resetModules(),require("../utils/address-autocomplete-common"),require("../address-autocomplete");const e=window.wc.addressAutocomplete.registerAddressAutocompleteProvider({id:"test-provider",canSearch:()=>{},search:()=>{},select:()=>{}});expect(e).toBe(!1),expect(console).toHaveErroredWith("Error registering address provider:","Provider test-provider not registered on server")}),test("should handle invalid address_providers type",()=>{delete global.window.wc,global.window.wc_address_autocomplete_params=undefined,jest.resetModules(),require("../utils/address-autocomplete-common"),require("../address-autocomplete");const e=window.wc.addressAutocomplete.registerAddressAutocompleteProvider({id:"test-provider",canSearch:()=>{},search:()=>{},select:()=>{}});expect(e).toBe(!1),expect(console).toHaveErroredWith("Error registering address provider:","Provider test-provider not registered on server")}),test("should reject provider without ID",()=>{const e=window.wc.addressAutocomplete.registerAddressAutocompleteProvider({canSearch:()=>{},search:()=>{},select:()=>{}});expect(e).toBe(!1),expect(console).toHaveErroredWith("Error registering address provider:","Address provider must have a valid ID")}),test("should reject provider with non-string ID",()=>{const e=window.wc.addressAutocomplete.registerAddressAutocompleteProvider({id:123,canSearch:()=>{},search:()=>{},select:()=>{}});expect(e).toBe(!1),expect(console).toHaveErroredWith("Error registering address provider:","Address provider must have a valid ID")}),test("should reject provider without canSearch function",()=>{const e=window.wc.addressAutocomplete.registerAddressAutocompleteProvider({id:"test-provider",search:()=>{},select:()=>{}});expect(e).toBe(!1),expect(console).toHaveErroredWith("Error registering address provider:","Address provider must have a canSearch function")}),test("should reject provider without search function",()=>{const e=window.wc.addressAutocomplete.registerAddressAutocompleteProvider({id:"test-provider",canSearch:()=>{},select:()=>{}});expect(e).toBe(!1),expect(console).toHaveErroredWith("Error registering address provider:","Address provider must have a search function")}),test("should reject provider without select function",()=>{const e=window.wc.addressAutocomplete.registerAddressAutocompleteProvider({id:"test-provider",canSearch:()=>{},search:()=>{}});expect(e).toBe(!1),expect(console).toHaveErroredWith("Error registering address provider:","Address provider must have a select function")}),test("should reject provider not registered on server",()=>{const e=window.wc.addressAutocomplete.registerAddressAutocompleteProvider({id:"unregistered-provider",canSearch:()=>{},search:()=>{},select:()=>{}});expect(e).toBe(!1),expect(console).toHaveErroredWith("Error registering address provider:","Provider unregistered-provider not registered on server")}),test("should freeze provider after successful registration",()=>{const e=window.wc.addressAutocomplete.registerAddressAutocompleteProvider({id:"test-provider",canSearch:()=>{},search:()=>{},select:()=>{}});expect(e).toBe(!0),expect(Object.isFrozen(window.wc.addressAutocomplete.providers["test-provider"])).toBe(!0),expect(()=>{window.wc.addressAutocomplete.providers["test-provider"].newProp="test"}).toThrow(TypeError),expect(window.wc.addressAutocomplete.providers["test-provider"].newProp).toBeUndefined()}),test("should not allow duplicate provider registration",()=>{const e=jest.spyOn(console,"warn").mockImplementation(()=>{}),t=window.wc.addressAutocomplete.registerAddressAutocompleteProvider({id:"test-provider",canSearch:()=>!1,search:()=>["original"],select:()=>{}});expect(t).toBe(!0);const s=window.wc.addressAutocomplete.registerAddressAutocompleteProvider({id:"test-provider",canSearch:()=>!0,search:()=>["duplicate"],select:()=>{}});expect(s).toBe(!1),expect(e).toHaveBeenCalledWith('Address provider with ID "test-provider" is already registered.'),expect(window.wc.addressAutocomplete.providers["test-provider"].canSearch()).toBe(!1),expect(window.wc.addressAutocomplete.providers["test-provider"].search()).toEqual(["original"]),e.mockRestore()}),test("should allow multiple providers with different IDs",()=>{const e=window.wc.addressAutocomplete.registerAddressAutocompleteProvider({id:"provider-1",canSearch:()=>!0,search:()=>["provider1-results"],select:()=>{}}),t=window.wc.addressAutocomplete.registerAddressAutocompleteProvider({id:"provider-2",canSearch:()=>!0,search:()=>["provider2-results"],select:()=>{}});expect(e).toBe(!0),expect(t).toBe(!0),expect(window.wc.addressAutocomplete.providers["provider-1"]).toBeDefined(),expect(window.wc.addressAutocomplete.providers["provider-2"]).toBeDefined(),expect(window.wc.addressAutocomplete.providers["provider-1"].search()).toEqual(["provider1-results"]),expect(window.wc.addressAutocomplete.providers["provider-2"].search()).toEqual(["provider2-results"])})}),describe("Address Suggestions Component",()=>{let e,t,s;beforeEach(async()=>{document.body.innerHTML="",delete global.window.wc,global.window.jQuery=jest.fn(e=>({hasClass:jest.fn(()=>!1),trigger:jest.fn(),select2:jest.fn(),on:jest.fn()})),Object.assign(global.window,{DOMPurify:{sanitize:e=>e},wc_address_autocomplete_common_params:{address_providers:JSON.stringify([{id:"test-provider",name:"Test provider",branding_html:'<div class="provider-branding">Powered by Test Provider</div>'},{id:"test-provider-unbranded",name:"Test provider unbranded"}])}});const o=document.createElement("form"),n=document.createElement("select");n.id="billing_country";const i=document.createElement("option");i.value="US",i.selected=!0,n.appendChild(i),n.value="US";const r=document.createElement("input");r.id="billing_address_1",r.type="text";const d=document.createElement("input");d.id="billing_city",d.type="text";const c=document.createElement("input");c.id="billing_postcode",c.type="text";const a=document.createElement("input");a.id="billing_state",a.type="text";const l=document.createElement("div");l.className="woocommerce-input-wrapper",l.appendChild(r);const u=document.createElement("select");u.id="shipping_country";const p=document.createElement("option");p.value="US",p.selected=!0,u.appendChild(p),u.value="US";const m=document.createElement("input");m.id="shipping_address_1",m.type="text";const g=document.createElement("input");g.id="shipping_city",g.type="text";const v=document.createElement("input");v.id="shipping_postcode",v.type="text";const w=document.createElement("input");w.id="shipping_state",w.type="text";const h=document.createElement("div");h.className="woocommerce-input-wrapper",h.appendChild(m),o.appendChild(n),o.appendChild(l),o.appendChild(d),o.appendChild(c),o.appendChild(a),o.appendChild(u),o.appendChild(h),o.appendChild(g),o.appendChild(v),o.appendChild(w),document.body.appendChild(o),t=r,s=m,e={id:"test-provider",canSearch:jest.fn(e=>"US"===e),search:jest.fn(async(e,t,s)=>[{id:"addr1",label:"123 Main Street, City, US",matchedSubstrings:[{offset:0,length:3}]},{id:"addr2",label:"456 Oak Avenue, Town, US",matchedSubstrings:[{offset:0,length:3}]}]),select:jest.fn(async e=>({address_1:"123 Main Street",city:"City",postcode:"12345",country:"US",state:"CA"}))},jest.resetModules(),require("../utils/address-autocomplete-common"),require("../address-autocomplete"),window.wc.addressAutocomplete.registerAddressAutocompleteProvider(e);const y=new Event("DOMContentLoaded");document.dispatchEvent(y),await new Promise(e=>setTimeout(e,10))}),afterEach(()=>{jest.clearAllMocks(),window.wc&&window.wc.addressAutocomplete&&(window.wc.addressAutocomplete.providers={},window.wc.addressAutocomplete.activeProvider={billing:null,shipping:null})}),describe("DOM Initialization",()=>{test("should create suggestions container for address inputs",()=>{const e=document.getElementById("address_suggestions_billing"),t=document.getElementById("address_suggestions_shipping");expect(e).toBeTruthy(),expect(t).toBeTruthy(),expect(e.className).toBe("woocommerce-address-suggestions"),expect(e.style.display).toBe("none"),expect(e.getAttribute("role")).toBe("region"),expect(e.getAttribute("aria-live")).toBe("polite");const s=e.querySelector(".suggestions-list");expect(s).toBeTruthy(),expect(s.getAttribute("role")).toBe("listbox"),expect(s.getAttribute("aria-label")).toBe("Address suggestions");const o=document.querySelector(".address-search-icon");expect(o).toBeTruthy()}),test("should set active provider based on country value",()=>{expect(window.wc.addressAutocomplete.activeProvider.billing).toBe(e),expect(window.wc.addressAutocomplete.activeProvider.shipping).toBe(e)}),test("should add autocomplete-available class when provider is active",()=>{const e=t.closest(".woocommerce-input-wrapper"),o=s.closest(".woocommerce-input-wrapper");expect(e.classList.contains("autocomplete-available")).toBe(!0),expect(o.classList.contains("autocomplete-available")).toBe(!0)})}),describe("Active Provider Management",()=>{test("should set active provider when country matches canSearch criteria",()=>{const t=document.getElementById("billing_country");t.value="US",t.dispatchEvent(new Event("change")),expect(e.canSearch).toHaveBeenCalledWith("US"),expect(window.wc.addressAutocomplete.activeProvider.billing).toBe(e)}),test("should clear active provider when country does not match canSearch criteria",()=>{const t=document.getElementById("billing_country"),s=document.createElement("option");s.value="FR",t.appendChild(s),t.value="FR",t.dispatchEvent(new Event("change")),expect(e.canSearch).toHaveBeenCalledWith("FR"),expect(window.wc.addressAutocomplete.activeProvider.billing).toBe(null)}),test("should remove autocomplete-available class when no provider is active",()=>{const e=document.getElementById("billing_country"),s=t.closest(".woocommerce-input-wrapper");e.value="FR",e.dispatchEvent(new Event("change")),expect(s.classList.contains("autocomplete-available")).toBe(!1)}),test("should handle country change for both billing and shipping",()=>{const t=document.getElementById("billing_country"),s=document.getElementById("shipping_country"),o=document.createElement("option");o.value="FR",t.appendChild(o),t.value="FR",t.dispatchEvent(new Event("change")),s.dispatchEvent(new Event("change")),expect(window.wc.addressAutocomplete.activeProvider.billing).toBe(null),expect(window.wc.addressAutocomplete.activeProvider.shipping).toBe(e)})}),describe("Address Suggestions Display",()=>{test("should not display suggestions for input less than 3 characters",async()=>{t.value="ab",t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150));const s=document.querySelector("#address_suggestions_billing .suggestions-list");expect(s.innerHTML).toBe(""),expect(e.search).not.toHaveBeenCalled()}),test("should hide suggestions when input goes from 3+ characters to less than 3",async()=>{t.value="123",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150));const e=document.getElementById("address_suggestions_billing");expect(e.style.display).toBe("block"),t.value="12",t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150)),expect(e.style.display).toBe("none")}),test("should display suggestions for input with 3 or more characters",async()=>{t.value="123",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150)),expect(e.search).toHaveBeenCalledWith("123","US","billing");const s=document.querySelector("#address_suggestions_billing .suggestions-list").querySelectorAll("li");expect(s).toHaveLength(2),expect(s[0].textContent).toContain("123 Main Street"),expect(s[1].textContent).toContain("456 Oak Avenue")}),test("should highlight matched text in suggestions",async()=>{t.value="123",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150));const e=document.querySelector("#address_suggestions_billing .suggestions-list").querySelector("li").querySelector("strong");expect(e).toBeTruthy(),expect(e.textContent).toBe("123")}),test("should limit suggestions to maximum of 5",async()=>{e.search.mockResolvedValue(Array.from({length:10},(e,t)=>({id:`addr${t}`,label:`${t} Test Street`,matchedSubstrings:[]}))),t.value="test",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150));const s=document.querySelector("#address_suggestions_billing .suggestions-list").querySelectorAll("li");expect(s).toHaveLength(5)}),test("should hide suggestions when no results returned",async()=>{e.search.mockResolvedValue([]),t.value="xyz",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150));const s=document.getElementById("address_suggestions_billing");expect(s.style.display).toBe("none")}),test("should hide suggestions and log error when search throws exception",async()=>{e.search.mockRejectedValue(new Error("Search failed"));const s=jest.spyOn(console,"error").mockImplementation(()=>{});t.value="test",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150));const o=document.getElementById("address_suggestions_billing");expect(o.style.display).toBe("none"),expect(s).toHaveBeenCalledWith("Address search error:",expect.any(Error)),s.mockRestore()})}),describe("Keyboard Navigation",()=>{beforeEach(async()=>{t.value="123",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150))}),test("should navigate down with ArrowDown key",()=>{const e=document.querySelectorAll("#address_suggestions_billing .suggestions-list li");expect(e[0].classList.contains("active")).toBe(!1),expect(e[0].getAttribute("aria-selected")).toBe(null);const s=new KeyboardEvent("keydown",{key:"ArrowDown",bubbles:!0});t.dispatchEvent(s),expect(e[0].classList.contains("active")).toBe(!0),expect(e[0].getAttribute("aria-selected")).toBe("true"),expect(e[1].classList.contains("active")).toBe(!1)}),test("should navigate up with ArrowUp key",()=>{const e=document.querySelectorAll("#address_suggestions_billing .suggestions-list li");let s=new KeyboardEvent("keydown",{key:"ArrowDown",bubbles:!0});t.dispatchEvent(s),s=new KeyboardEvent("keydown",{key:"ArrowDown",bubbles:!0}),t.dispatchEvent(s),s=new KeyboardEvent("keydown",{key:"ArrowUp",bubbles:!0}),t.dispatchEvent(s),expect(e[0].classList.contains("active")).toBe(!0),expect(e[1].classList.contains("active")).toBe(!1)}),test("should wrap around when navigating beyond bounds",()=>{const e=document.querySelectorAll("#address_suggestions_billing .suggestions-list li");let s=new KeyboardEvent("keydown",{key:"ArrowDown",bubbles:!0});t.dispatchEvent(s),s=new KeyboardEvent("keydown",{key:"ArrowDown",bubbles:!0}),t.dispatchEvent(s),s=new KeyboardEvent("keydown",{key:"ArrowDown",bubbles:!0}),t.dispatchEvent(s),expect(e[0].classList.contains("active")).toBe(!0),expect(e[1].classList.contains("active")).toBe(!1)}),test("should select address with Enter key",async()=>{let s=new KeyboardEvent("keydown",{key:"ArrowDown",bubbles:!0});t.dispatchEvent(s),s=new KeyboardEvent("keydown",{key:"Enter",bubbles:!0}),t.dispatchEvent(s),await new Promise(e=>setTimeout(e,250)),expect(e.select).toHaveBeenCalledWith("addr1");const o=document.getElementById("address_suggestions_billing");expect(o.style.display).toBe("none")}),test("should hide suggestions with Escape key",()=>{const e=document.getElementById("address_suggestions_billing");expect(e.style.display).toBe("block");const s=new KeyboardEvent("keydown",{key:"Escape",bubbles:!0});t.dispatchEvent(s),expect(e.style.display).toBe("none")}),test("should not handle keyboard events when suggestions are hidden",()=>{const e=new KeyboardEvent("keydown",{key:"Escape",bubbles:!0});t.dispatchEvent(e);const s=new KeyboardEvent("keydown",{key:"ArrowDown",bubbles:!0});expect(()=>{t.dispatchEvent(s)}).not.toThrow()})}),describe("Address Selection",()=>{test("should populate address fields when address is selected",async()=>{t.value="123",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150)),document.querySelector("#address_suggestions_billing .suggestions-list li").click(),await new Promise(e=>setTimeout(e,250)),expect(e.select).toHaveBeenCalledWith("addr1"),expect(document.getElementById("billing_address_1").value).toBe("123 Main Street"),expect(document.getElementById("billing_city").value).toBe("City"),expect(document.getElementById("billing_postcode").value).toBe("12345"),expect(document.getElementById("billing_country").value).toBe("US"),expect(document.getElementById("billing_state").value).toBe("CA")}),test("should handle partial address data from provider",async()=>{e.select.mockResolvedValue({address_1:"123 Main Street",city:"City"}),t.value="123",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150)),document.querySelector("#address_suggestions_billing .suggestions-list li").click(),await new Promise(e=>setTimeout(e,250)),expect(document.getElementById("billing_address_1").value).toBe("123 Main Street"),expect(document.getElementById("billing_city").value).toBe("City"),expect(document.getElementById("billing_postcode").value).toBe("")}),test("should clear existing field values when not present in selected address data",async()=>{const s=document.createElement("input");s.id="billing_address_2",s.type="text",s.value="Apt 101",document.querySelector("form").appendChild(s),document.getElementById("billing_city").value="Old City",document.getElementById("billing_postcode").value="99999",document.getElementById("billing_state").value="TX",e.select.mockResolvedValue({address_1:"456 Oak Avenue",city:"New City",country:"US"}),t.value="456",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150)),document.querySelector("#address_suggestions_billing .suggestions-list li").click(),await new Promise(e=>setTimeout(e,250)),expect(document.getElementById("billing_address_1").value).toBe("456 Oak Avenue"),expect(document.getElementById("billing_city").value).toBe("New City"),expect(document.getElementById("billing_country").value).toBe("US"),expect(document.getElementById("billing_address_2").value).toBe(""),expect(document.getElementById("billing_postcode").value).toBe(""),expect(document.getElementById("billing_state").value).toBe("")}),test("should only clear fields that exist and have values",async()=>{document.getElementById("billing_city").value="Existing City",document.getElementById("billing_postcode").value="12345",e.select.mockResolvedValue({address_1:"789 Pine Street",state:"CA",country:"US"}),t.value="789",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150)),document.querySelector("#address_suggestions_billing .suggestions-list li").click(),await new Promise(e=>setTimeout(e,250)),expect(document.getElementById("billing_address_1").value).toBe("789 Pine Street"),expect(document.getElementById("billing_state").value).toBe("CA"),expect(document.getElementById("billing_country").value).toBe("US"),expect(document.getElementById("billing_city").value).toBe(""),expect(document.getElementById("billing_postcode").value).toBe("")}),test("should handle provider selection errors gracefully",async()=>{e.select.mockRejectedValue(new Error("Selection failed"));const s=jest.spyOn(console,"error").mockImplementation(()=>{});t.value="123",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150)),document.querySelector("#address_suggestions_billing .suggestions-list li").click(),await new Promise(e=>setTimeout(e,250)),expect(s).toHaveBeenCalledWith("Error selecting address from provider","test-provider",expect.any(Error)),expect(document.getElementById("billing_address_1").value).toBe("123"),s.mockRestore()}),test("should handle invalid address data from provider",async()=>{e.select.mockResolvedValue(null),t.value="123",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150)),document.querySelector("#address_suggestions_billing .suggestions-list li").click(),await new Promise(e=>setTimeout(e,250)),expect(document.getElementById("billing_address_1").value).toBe("123")})}),describe("Browser Autofill Management",()=>{test("should disable browser autofill when suggestions are shown",async()=>{t.value="123",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150)),expect(t.getAttribute("autocomplete")).toBe("none"),expect(t.getAttribute("data-lpignore")).toBe("true"),expect(t.getAttribute("data-op-ignore")).toBe("true"),expect(t.getAttribute("data-1p-ignore")).toBe("true")}),test("should enable browser autofill when suggestions are hidden",async()=>{t.value="123",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150)),t.value="xy",t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150)),expect(t.getAttribute("autocomplete")).toBe("address-line1"),expect(t.getAttribute("data-lpignore")).toBe("false")})}),describe("Security and Sanitization",()=>{test("should sanitize input values for XSS protection",async()=>{const s=jest.spyOn(console,"warn").mockImplementation(()=>{});t.value='<script>alert("xss")<\/script>',t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150)),expect(s).toHaveBeenCalledWith("Input was sanitized for security"),expect(e.search).toHaveBeenCalledWith('alert("xss")',"US","billing"),s.mockRestore()}),test("should handle invalid match data safely",async()=>{e.search.mockResolvedValue([{id:"addr1",label:"123 Main Street",matchedSubstrings:[{offset:-1,length:5},{offset:50,length:10},{offset:0,length:-1},null]}]),t.value="123",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150));const s=document.querySelector("#address_suggestions_billing .suggestions-list").querySelector("li");expect(s.textContent).toBe("123 Main Street"),expect(s.querySelector("strong")).toBe(null)})}),describe("Click Outside Behavior",()=>{test("should hide suggestions when clicking outside",async()=>{t.value="123",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150));const e=document.getElementById("address_suggestions_billing");expect(e.style.display).toBe("block");const s=document.createElement("div");document.body.appendChild(s),s.click(),expect(e.style.display).toBe("none")}),test("should not hide suggestions when clicking inside suggestions container",async()=>{t.value="123",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150));const e=document.getElementById("address_suggestions_billing");expect(e.style.display).toBe("block"),e.click(),expect(e.style.display).toBe("block")}),test("should not hide suggestions when clicking address input",async()=>{t.value="123",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150));const e=document.getElementById("address_suggestions_billing");expect(e.style.display).toBe("block"),t.click(),expect(e.style.display).toBe("block")})}),describe("Branding HTML",()=>{test("should display branding HTML when suggestions are shown",async()=>{t.value="123",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150));const e=document.getElementById("address_suggestions_billing").querySelector(".woocommerce-address-autocomplete-branding");expect(e).toBeTruthy(),expect(e.innerHTML).toBe('<div class="provider-branding">Powered by Test Provider</div>')}),test.skip("should hide branding HTML when suggestions are hidden",async()=>{t.value="123",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150));const e=document.getElementById("address_suggestions_billing");let s=e.querySelector(".woocommerce-address-autocomplete-branding");expect(s.innerHTML).toBe('<div class="provider-branding">Powered by Test Provider</div>'),expect(s.style.display).toBe("flex"),t.value="xy",t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150)),s=e.querySelector(".woocommerce-address-autocomplete-branding"),expect(s).toBeTruthy(),expect(s.style.display).toBe("none")}),test("should not create branding element when provider has no branding_html",async()=>{jest.resetModules(),window.wc.addressAutocomplete.providers=[],require("../address-autocomplete"),window.wc.addressAutocomplete.registerAddressAutocompleteProvider({search:e,select:e,canSearch:e,id:"mock-provider-unbranded"});const s=new Event("DOMContentLoaded");document.dispatchEvent(s),await new Promise(e=>setTimeout(e,10)),t.value="456",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150));const o=document.getElementById("address_suggestions_billing").querySelector(".woocommerce-address-autocomplete-branding");expect(o).toBeFalsy()}),test("should reuse existing branding element on subsequent searches",async()=>{t.value="123",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150));const e=document.getElementById("address_suggestions_billing"),s=e.querySelector(".woocommerce-address-autocomplete-branding");t.value="12",t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150)),t.value="456",t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150));const o=e.querySelector(".woocommerce-address-autocomplete-branding");expect(o).toBe(s),expect(o.innerHTML).toBe('<div class="provider-branding">Powered by Test Provider</div>')}),test("should remove branding element when country changes",async()=>{t.value="123",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150));const e=document.getElementById("address_suggestions_billing");let s=e.querySelector(".woocommerce-address-autocomplete-branding");expect(s).toBeTruthy();const o=document.getElementById("billing_country"),n=document.createElement("option");n.value="FR",o.appendChild(n),o.value="FR",o.dispatchEvent(new Event("change")),s=e.querySelector(".woocommerce-address-autocomplete-branding"),expect(s).toBeFalsy()}),test("should display branding HTML for both billing and shipping if DOMPurify is present",async()=>{t.value="123",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150)),window.DOMPurify={sanitize:e=>e};const e=document.getElementById("address_suggestions_billing").querySelector(".woocommerce-address-autocomplete-branding");expect(e).toBeTruthy(),expect(e.innerHTML).toBe('<div class="provider-branding">Powered by Test Provider</div>'),s.value="456",s.focus(),s.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150));const o=document.getElementById("address_suggestions_shipping").querySelector(".woocommerce-address-autocomplete-branding");expect(o).toBeTruthy(),expect(o.innerHTML).toBe('<div class="provider-branding">Powered by Test Provider</div>')}),test("should not display branding HTML for both billing and shipping if DOMPurify is not present",async()=>{delete window.DOMPurify,t.value="123",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150));const e=document.getElementById("address_suggestions_billing").querySelector(".woocommerce-address-autocomplete-branding");expect(e).toBeNull(),s.value="456",s.focus(),s.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150));const o=document.getElementById("address_suggestions_shipping").querySelector(".woocommerce-address-autocomplete-branding");expect(o).toBeNull()})}),describe("Blur Event Behavior",()=>{test("should hide suggestions when input loses focus",async()=>{t.value="123",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150));const e=document.getElementById("address_suggestions_billing");expect(e.style.display).toBe("block"),t.dispatchEvent(new Event("blur")),await new Promise(e=>setTimeout(e,250)),expect(e.style.display).toBe("none")}),test("should not refocus input when blurred with suggestions active",async()=>{t.value="123",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150));const e=document.getElementById("address_suggestions_billing");expect(e.style.display).toBe("block");const s=document.createElement("input");document.body.appendChild(s),t.blur(),s.focus(),await new Promise(e=>setTimeout(e,250)),expect(document.activeElement).toBe(s),expect(e.style.display).toBe("none"),document.body.removeChild(s)}),test("should not have blur event listener when suggestions are not shown",()=>{const e=document.getElementById("address_suggestions_billing");expect(e.style.display).toBe("none"),expect(()=>{t.dispatchEvent(new Event("blur"))}).not.toThrow()}),test("should enable browser autofill without refocusing when suggestions are hidden via blur",async()=>{t.value="123",t.focus(),t.dispatchEvent(new Event("input")),await new Promise(e=>setTimeout(e,150)),expect(t.getAttribute("autocomplete")).toBe("none"),t.dispatchEvent(new Event("blur")),await new Promise(e=>setTimeout(e,250)),expect(t.getAttribute("autocomplete")).toBe("address-line1"),expect(t.getAttribute("data-lpignore")).toBe("false")})})});